#include <arduino.h>
#include "arduino_secrets.h" 
#include <Arduino_FreeRTOS.h>
#include "FenceLedControl.h"

extern	volatile dt4byte	ledbuf[];	// led display data buffer
extern	uint8_t				patSelNo;
//extern 	SemaphoreHandle_t	semBuf;
extern	uint8_t				trMode;
extern	void semTake();
extern	void semGive();
extern	uint16_t corrBright;

// 範囲指定ランダム関数簡易版
uint8_t rand_range(uint8_t n1, uint8_t n2) {
	return n1 + rand() % (n2 - n1);
}

volatile int	cnt1,cnt2,cnt3,cnt4,cnt5,cnt6,cnt7,cnt8,cnt99;

// 発光パターン更新の際、オーバーフロータイプの描画時間カウンタを最大値に
// プリセットしておき、更新イベントが即時おこるようにしておく
void	resetCounter() {
	cnt1 = LIM1;
	cnt2 = LIM2;
	cnt3 = LIM3;
	cnt4 = LIM4;
	cnt5 = LIM5;
	cnt6 = LIM6;
	cnt7 = LIM7;
	cnt8 = LIM8;
	cnt99 = LIM99;
}

// blink[10] の3～10個の要素にランダム0～31の異なる値を設定する関数。ランダム値以外は99を挿入
void generate_blink(uint8_t *blink) {
	uint8_t used[32] = {0}; // 使用済みフラグ（0～31）
	uint8_t count = 0;
	uint8_t max_select = rand_range(3, 10); // 選択数（3～10のランダム）

	while (count < max_select) {
		int val = rand_range(0, 31);
		if (!used[val]) {	// 同じ値をはじく
			used[val] = 1;
			blink[count++] = val;
		}
	}
	for (uint8_t i=count; i<10; i++) blink[i]=99;	// 残りを 99 にする
}

// LEDの点灯パターンを作成（50msサイクル）
void ledPatternMakeTask(void *pvParameters) {
	dt4byte ledpat;
	int cnt;
	resetCounter();
	vTaskDelay(100);
	uint8_t blink[BLINKMAX];
	float	xx[BLINKMAX]={0.0f};

	while(1) {
		ledpat.BR = corrBright;
		switch(patSelNo) {
			case 1:	// クールホワイト点灯
				if(++cnt1>LIM1) {	// 輝度制御のため、60秒ごとにチェンジ
					ledpat.COL = 0x20;
					trMode = 1;		// 3byte転送モード
					semTake();
					for(int i=0;i<32;i++) ledbuf[i].d32 = ledpat.d32;
					semGive();
					cnt1=0;
				}
				break;
			case 2:	// ウォームホワイト点灯
				if(++cnt2>LIM2) {	// 輝度制御のため、60秒ごとにチェンジ
					trMode = 0;		// 5byte転送モード
					semTake();
					for(int i=0;i<32;i++) {	// プリセット色でオレンジ過ぎたのでRGB指定にした
						ledpat.R = 105;
						ledpat.G = 95;
						ledpat.B = 42;
						ledbuf[i].d32 = ledpat.d32;
					}
					semGive();
					cnt2=0;
				}
				break;
			case 3:	// クール/ウォーム mix ところどころ1/f
				if(++cnt3>LIM3) {	// 1分
					trMode = 1;		// 3byte転送モード
					cnt3=0;
					for(int i=0;i<32;i++) {
						ledbuf[i].COL=rand_range(0x20,0x22);
						ledbuf[i].BR=ledpat.BR;
					}
					generate_blink(blink);	// ランダム点灯するNoを計算しblink[]に入れる
				}
				for(uint8_t ib=0;ib<BLINKMAX;ib++) {	// ランダムな最大BLINKMAX個を揺らぎ点滅させる
					if(blink[ib]!=99) {
						float x=xx[ib];
						if(x<0.5) {
							x = x + 2 * x * x ;
						} else {
							x = x - 2 * (1.0 - x) * (1.0 - x);
						}
						if ((x<0.001) || (x>0.999)) {	// 1.0と0.0に張付きやすいのでランダム要素を入れる
							x = (float)(rand_range(0,127))/127;
						}
						xx[ib] = x;
						x = x * (float)(corrBright-4) + 4.0f;	// 輝度変数を掛ける。1/f点滅は完全な消灯にはしない
						ledbuf[blink[ib]].BR = (uint8_t)x;
					}
				}
				break;			
			case 4:	// セピア　暖色系
				if(++cnt4>LIM4) {	// 1秒ごとにチェンジ
					trMode = 1;		// 3byte転送モード
					semTake();
					for(int i=0;i<32;i++) {
						ledpat.COL = (uint8_t)rand_range(0x0,0x8);
						ledbuf[i].d32 = ledpat.d32;
					}
					semGive();
					cnt4 = 0;
				}
				break;			
			case 5:	// セピア　ブルー系
				if(++cnt5>LIM5) {	// 1秒ごとにチェンジ
					trMode = 0;		// 5byte転送モード
					semTake();
					for(int i=0;i<32;i++) {
						ledpat.R = rand_range(20,71);
						ledpat.G = rand_range(20,102);
						ledpat.B = rand_range(57,77);
						ledbuf[i].d32 = ledpat.d32;
					}
					semGive();
					cnt5 = 0;
				}
				break;
			case 6:	// セピア　グリーン系
				if(++cnt6>LIM6) {	// 1秒ごとにチェンジ
					trMode = 1;		// 3byte転送モード
					semTake();
					for(int i=0;i<32;i++) {
						ledpat.COL = (uint8_t)rand_range(0x10,0x18);
						ledbuf[i].d32 = ledpat.d32;
					}
					semGive();
					cnt6 = 0;
				}
				break;
			case 7:	// pureカラー時々チェンジ
				if(++cnt7>LIM7) {	// 20秒ごとにチェンジ
					trMode = 1;		// 3byte転送モード
					semTake();
					for(int i=0;i<32;i++) {
						ledpat.COL = (uint8_t)rand_range(0x18,0x20);
						ledbuf[i].d32 = ledpat.d32;
					}
					semGive();
					cnt7 = 0;
				}
				break;			
			case 8:	// pureカラー数秒でチェンジ＆点滅
				if(++cnt8>LIM8) {	// 2秒ごとにチェンジ
					trMode = 1;		// 3byte転送モード
					for(int i=0;i<32;i++) {
						if (rand_range(0,10)>=6) ledpat.COL=34; else ledpat.COL=rand_range(24,32);
						semTake();
						ledbuf[i].d32 = ledpat.d32;
						semGive();
					}
					cnt8=0;
				}
				break;
			case 99:	// 一個ずつ点灯させるテストパターン
				if(++cnt99>LIM99) {
					ledpat.BR = 0;
					ledpat.COL = 0;
					ledbuf[cnt].d32 = ledpat.d32;
					trMode = 1;	// 3byte転送モード
					cnt++;
					uint8_t colNo;
					if(cnt==14) cnt=16;
					else if(cnt==30) {
						cnt=0;
						if(++colNo>33) colNo=0;
					}
					ledpat.BR = 127;
					ledpat.COL = colNo;
					ledbuf[cnt].d32 = ledpat.d32;
					cnt99=0;
				}
				break;
			default: break;
		}
		vTaskDelay(50);
	}
}
